$(function() {
	
	loadData();
	
});

function moveUp(id,rank)
{
	$.post("json/moveUp.php",
	  {
		record_id:id,
		record_rank:rank
	  },
	  function(data,status){
		loadData();
	  });
}

function moveDown(id,rank)
{
	$.post("json/moveDown.php",
	  {
		record_id:id,
		record_rank:rank
	  },
	  function(data,status){
		loadData();
	  });
}



function loadData()
{
	var serializedData = $("#form1").serialize();
	$.ajax({
		url: "json/getData.php",
		type: "GET",
		data: serializedData,
		dataType: "jsonp",
		success: function(data){
			var total = data.total;
			var str = '';
			if(total>0){
				$('#dataTableBody').empty();
				for(var i=0; i<total; i++){
					
					var memberStatus = "";
					if(data[i].team_status == 1)
					{
						memberStatus = '<span class="label label-sm label-success">Active</span>';	
					}else{
						memberStatus = '<span class="label label-sm label-danger">Inactive</span>';	
					}
					if(i == 0){
						moveupbutton = '<a href="#" class="btn default btn-xs yellow-stripe disabled">Move Up</a>';
					}else{
						moveupbutton = '<a href="javascript:moveUp('+data[i].team_id+','+data[i].team_rank+');" class="btn default btn-xs yellow-stripe">Move Up</a>';
					}
					if(i == total-1){
						movedownbutton = '<a href="#" class="btn default btn-xs blue-stripe disabled">Move Down</a>';
					}else{
						movedownbutton = '<a href="javascript:moveDown('+data[i].team_id+','+data[i].team_rank+');" class="btn default btn-xs blue-stripe">Move Down</a>';
					}
					
					
					str = '<tr><td>'+(i+1)+'</td><td align="center"><a href="../../images/'+data[i].team_image+'" class="fancybox-button"><i class="icon-picture"></i></a></td><td>'+data[i].team_name+'</td><td>'+data[i].team_position+'</td><td>'+data[i].team_mail+'</td><td>'+memberStatus+'</td><td>'+moveupbutton+movedownbutton+'<a href="update.php?recordid='+data[i].team_id+'" class="btn default btn-xs green-stripe">Edit</a><a href="javascript:deleteItemTrigger('+data[i].team_id+');" class="btn default btn-xs red-stripe">Delete</a></td></tr>';
					$('#dataTable > tbody:last').append(str);
				}
				
				
			}else{
			}
		},
		error: function(){
		}
	});
}